#include "variables.h"

/**********************************************************************************************************************************************************************************
 * 1Channel ODC Variables
 * *******************************************************************************************************************************************************************************/
VariablesInput::VariablesInput (EtherCATSlave *slave) :
	fwdPowerSetPoint(slave, 0),
	frequencySetPoint(slave, 4),
	sweepStartFrequency(slave, 8),
	sweepStopFrequency(slave, 12),
	sweepStepFrequency(slave, 16),
	sweepPower(slave, 20),
	dllLowerFrequency(slave, 24),
	dllUpperFrequency(slave, 28),
	dllStartFrequency(slave, 32),
	dllStepFrequency(slave, 36),
	dllThreshold(slave, 40),
	commands(slave, 44),
	phase(slave, 46),
	phaseGainBoardPhase1(slave, 48),
	phaseGainBoardPhase2(slave, 50),
	phaseGainBoardPhase3(slave, 52),
	phaseGainBoardPhase4(slave, 54),
	dllDelay(slave, 56),
	clockSource(slave, 57),
	pwmDutyCycle(slave, 58)
{}

VariablesOutput::VariablesOutput (EtherCATSlave *slave) :
	sgError(slave, 0),
	fwdPowerSetPoint(slave, 8),
	fwdPower(slave, 12),
	rflPower(slave, 16),
	returnLoss(slave, 20),
	actualFrequency(slave, 24),
	s11Frequency(slave, 28),
	s11Amplitude(slave, 32),
	amplitudeSweepStartFrequency(slave, 36),
	amplitudeSweepStopFrequency(slave, 40),
	sweepStartFrequency(slave, 44),
	sweepStopFrequency(slave, 48),
	sweepStepFrequency(slave, 52),
	sweepPower(slave, 56),
	pwmFrequency(slave, 60),
	status(slave, 64),
	temperature(slave, 66),
	psu1Voltage(slave, 68),
	psu1Current(slave, 70),
	psu1Power(slave, 72),
	psu2Voltage(slave, 74),
	psu2Current(slave, 76),
	psu2Power(slave, 78),
	psu3Voltage(slave, 80),
	psu3Current(slave, 82),
	psu3Power(slave, 84),
	psu4Voltage(slave, 86),
	psu4Current(slave, 88),
	psu4Power(slave, 90),
	psuPowerEfficiency(slave, 92),
	psuPowerDissipation(slave, 94),
	phase(slave, 96),
	phaseGainBoardPhase1(slave, 98),
	phaseGainBoardPhase2(slave, 100),
	phaseGainBoardPhase3(slave, 102),
	phaseGainBoardPhase4(slave, 104),
	pwmDutyCycle(slave, 106),
	clockSource(slave, 108)
{}


/**********************************************************************************************************************************************************************************
 * 1Channel Variables
 * *******************************************************************************************************************************************************************************/
VariablesInput_1channel::VariablesInput_1channel (EtherCATSlave *slave) :

	//float
	frequency_set_CH1(slave, 0),
	power_watt_set_CH1(slave, 4),
	SWP_freq_lower_set_CH1(slave, 8),
	SWP_freq_upper_set_CH1(slave, 12),
	SWP_freq_step_set_CH1(slave, 16),
	SWP_power_watt_set_CH1(slave, 20),
	DLL_freq_lower_set_CH1(slave, 24),
	DLL_freq_upper_set_CH1(slave, 28),
	DLL_freq_start_set_CH1(slave, 32),
	DLL_freq_step_set_CH1(slave, 36),
	DLL_threshold_set_CH1(slave, 40),

	//uint16_t
	commands_set_bitmask(slave, 44),
	phase_set_CH1(slave, 46),

	//uint8_t
	DLL_delay_set_CH1(slave, 48),
	PWM_duty_cycle_set_CH1(slave, 49),
	clock_source_set_CH1(slave, 50)

//	splitter_phase1_set(slave, 48),
//	splitter_phase2_set(slave, 50),
//	splitter_phase3_set(slave, 52),
//	splitter_phase4_set(slave, 54),

//	DLL_delay_set_CH1(slave, 56),
//	clock_source_set_CH1(slave, 57),
//	PWM_Duty_cycle_set_CH1(slave, 58)
{}

VariablesOutput_1channel::VariablesOutput_1channel (EtherCATSlave *slave) :

	//uint64_t
	error_bitmask_CH1(slave, 0),

	//float
	frequency_get_CH1(slave, 8),
	power_watt_get_CH1(slave, 12),
	FWD_power_watt_CH1(slave, 16),
	RFL_power_watt_CH1(slave, 20),
	S11_CH1(slave, 24),
	SWP_frequency_best_match_CH1(slave, 28),
	SWP_S11_best_match_CH1(slave, 32),
	SWP_S11_freq_lower_CH1(slave, 36),
	SWP_S11_freq_upper_CH1(slave, 40),
	SWP_freq_lower_get_CH1(slave, 44),
	SWP_freq_upper_get_CH1(slave, 48),
	SWP_freq_step_get_CH1(slave, 52),
	SWP_power_watt_get_CH1(slave, 56),
	PWM_frequency_get_CH1(slave, 60),

	//uint16_t
	status_bitmask_CH1(slave, 64),
	PA_temperature_CH1(slave, 66),
	PSU1_voltage(slave, 68),
	PSU1_current(slave, 70),
	PSU1_power(slave, 72),
	PSU2_voltage(slave, 74),
	PSU2_current(slave, 76),
	PSU2_power(slave, 78),
	PSU3_voltage(slave, 80),
	PSU3_current(slave, 82),
	PSU3_power(slave, 84),
	PSU4_voltage(slave, 86),
	PSU4_current(slave, 88),
	PSU4_power(slave, 90),
	PSU_power_efficiency(slave, 92),
	PSU_power_dissipation(slave, 94),
	phase_get_CH1(slave, 96),

	//uint8_t
	PWM_duty_cycle_get_CH1(slave, 98),
	clock_source_get_CH1(slave, 99)

//	splitter_phase1_get(slave, 98),
//	splitter_phase2_get(slave, 100),
//	splitter_phase3_get(slave, 102),
//	splitter_phase4_get(slave, 104),
{}


/**********************************************************************************************************************************************************************************
 * 4Channel Variables
 * *******************************************************************************************************************************************************************************/
VariablesInput_4channel::VariablesInput_4channel(EtherCATSlave *slave) :

//
// TODO:
// Below in comments is a register layout that has DLL delay
// Unfortunately it was running into issues for some reason, so it's not used.
//

//	frequency_set_CH1(slave, 0),
//	frequency_set_CH2(slave, 2),
//	frequency_set_CH3(slave, 4),
//	frequency_set_CH4(slave, 6),

//	power_watt_set_CH1(slave, 8),
//	power_watt_set_CH2(slave, 10),
//	power_watt_set_CH3(slave, 12),
//	power_watt_set_CH4(slave, 14),

//	VGA_attenuation_set_CH1(slave, 16),
//	VGA_attenuation_set_CH2(slave, 18),
//	VGA_attenuation_set_CH3(slave, 20),
//	VGA_attenuation_set_CH4(slave, 22),

//	IQMod_magnitude_set_CH1(slave, 24),
//	IQMod_magnitude_set_CH2(slave, 26),
//	IQMod_magnitude_set_CH3(slave, 28),
//	IQMod_magnitude_set_CH4(slave, 30),

//	DLL_freq_lower_set_CH1(slave, 32),
//	DLL_freq_lower_set_CH2(slave, 34),
//	DLL_freq_lower_set_CH3(slave, 36),
//	DLL_freq_lower_set_CH4(slave, 38),

//	DLL_freq_upper_set_CH1(slave, 40),
//	DLL_freq_upper_set_CH2(slave, 42),
//	DLL_freq_upper_set_CH3(slave, 44),
//	DLL_freq_upper_set_CH4(slave, 46),

//	DLL_freq_start_set_CH1(slave, 48),
//	DLL_freq_start_set_CH2(slave, 50),
//	DLL_freq_start_set_CH3(slave, 52),
//	DLL_freq_start_set_CH4(slave, 54),

//	DLL_freq_step_set_CH1(slave, 56),
//	DLL_freq_step_set_CH2(slave, 58),
//	DLL_freq_step_set_CH3(slave, 60),
//	DLL_freq_step_set_CH4(slave, 62),

//	DLL_threshold_set_CH1(slave, 64),
//	DLL_threshold_set_CH2(slave, 66),
//	DLL_threshold_set_CH3(slave, 68),
//	DLL_threshold_set_CH4(slave, 70),

//	DLL_delay_set_CH1(slave, 72),
//	DLL_delay_set_CH2(slave, 74),
//	DLL_delay_set_CH3(slave, 76),
//	DLL_delay_set_CH4(slave, 78),

//	SWP_freq_lower_set_CH1(slave, 80),
//	SWP_freq_lower_set_CH2(slave, 82),
//	SWP_freq_lower_set_CH3(slave, 84),
//	SWP_freq_lower_set_CH4(slave, 86),

//	SWP_freq_upper_set_CH1(slave, 88),
//	SWP_freq_upper_set_CH2(slave, 90),
//	SWP_freq_upper_set_CH3(slave, 82),
//	SWP_freq_upper_set_CH4(slave, 94),

//	SWP_freq_step_set_CH1(slave, 96),
//	SWP_freq_step_set_CH2(slave, 98),
//	SWP_freq_step_set_CH3(slave, 100),
//	SWP_freq_step_set_CH4(slave, 102),

//	SWP_power_watt_CH1(slave, 104),
//	SWP_power_watt_CH2(slave, 106),
//	SWP_power_watt_CH3(slave, 108),
//	SWP_power_watt_CH4(slave, 110),

//	RFE_DLL_set_bitmask(slave, 112),
//	AG_set_bitmask(slave, 113),
//	ERRC_SWP_execute_bitmask(slave, 114)



  frequency_set_CH1(slave, 0),
  frequency_set_CH2(slave, 2),
  frequency_set_CH3(slave, 4),
  frequency_set_CH4(slave, 6),

  power_watt_set_CH1(slave, 8),
  power_watt_set_CH2(slave, 10),
  power_watt_set_CH3(slave, 12),
  power_watt_set_CH4(slave, 14),

  VGA_attenuation_set_CH1(slave, 16),
  VGA_attenuation_set_CH2(slave, 18),
  VGA_attenuation_set_CH3(slave, 20),
  VGA_attenuation_set_CH4(slave, 22),

  IQMod_magnitude_set_CH1(slave, 24),
  IQMod_magnitude_set_CH2(slave, 26),
  IQMod_magnitude_set_CH3(slave, 28),
  IQMod_magnitude_set_CH4(slave, 30),

  DLL_freq_lower_set_CH1(slave, 32),
  DLL_freq_lower_set_CH2(slave, 34),
  DLL_freq_lower_set_CH3(slave, 36),
  DLL_freq_lower_set_CH4(slave, 38),

  DLL_freq_upper_set_CH1(slave, 40),
  DLL_freq_upper_set_CH2(slave, 42),
  DLL_freq_upper_set_CH3(slave, 44),
  DLL_freq_upper_set_CH4(slave, 46),

  DLL_freq_start_set_CH1(slave, 48),
  DLL_freq_start_set_CH2(slave, 50),
  DLL_freq_start_set_CH3(slave, 52),
  DLL_freq_start_set_CH4(slave, 54),

  DLL_freq_step_set_CH1(slave, 56),
  DLL_freq_step_set_CH2(slave, 58),
  DLL_freq_step_set_CH3(slave, 60),
  DLL_freq_step_set_CH4(slave, 62),

  DLL_threshold_set_CH1(slave, 64),
  DLL_threshold_set_CH2(slave, 66),
  DLL_threshold_set_CH3(slave, 68),
  DLL_threshold_set_CH4(slave, 70),

  SWP_freq_lower_set_CH1(slave, 72),
  SWP_freq_lower_set_CH2(slave, 74),
  SWP_freq_lower_set_CH3(slave, 76),
  SWP_freq_lower_set_CH4(slave, 78),

  SWP_freq_upper_set_CH1(slave, 80),
  SWP_freq_upper_set_CH2(slave, 82),
  SWP_freq_upper_set_CH3(slave, 84),
  SWP_freq_upper_set_CH4(slave, 86),

  SWP_freq_step_set_CH1(slave, 88),
  SWP_freq_step_set_CH2(slave, 90),
  SWP_freq_step_set_CH3(slave, 92),
  SWP_freq_step_set_CH4(slave, 94),

  SWP_power_watt_CH1(slave, 96),
  SWP_power_watt_CH2(slave, 98),
  SWP_power_watt_CH3(slave, 100),
  SWP_power_watt_CH4(slave, 102),

  RFE_DLL_set_bitmask(slave, 104),
  feedforward_enable_set_bitmask(slave, 105),
  ERRC_SWP_execute_bitmask(slave, 106)

//	error_clear_bitmask(slave, 16),
//	RF_enable_set_bitmask(slave, 17)
{}

VariablesOutput_4channel::VariablesOutput_4channel(EtherCATSlave *slave) :
	error_status_CH1(slave, 0),
	error_status_CH2(slave, 8),
	error_status_CH3(slave, 16),
	error_status_CH4(slave, 24),

	frequency_get_CH1(slave, 32),
	frequency_get_CH2(slave, 34),
	frequency_get_CH3(slave, 36),
	frequency_get_CH4(slave, 38),

	power_watt_get_CH1(slave, 40),
	power_watt_get_CH2(slave, 42),
	power_watt_get_CH3(slave, 44),
	power_watt_get_CH4(slave, 46),

	FWD_power_watt_CH1(slave, 48),
	FWD_power_watt_CH2(slave, 50),
	FWD_power_watt_CH3(slave, 52),
	FWD_power_watt_CH4(slave, 54),

	RFL_power_watt_CH1(slave, 56),
	RFL_power_watt_CH2(slave, 58),
	RFL_power_watt_CH3(slave, 60),
	RFL_power_watt_CH4(slave, 62),

	VGA_attenuation_get_CH1(slave, 64),
	VGA_attenuation_get_CH2(slave, 66),
	VGA_attenuation_get_CH3(slave, 68),
	VGA_attenuation_get_CH4(slave, 70),

	IQMod_magnitude_get_CH1(slave, 72),
	IQMod_magnitude_get_CH2(slave, 74),
	IQMod_magnitude_get_CH3(slave, 76),
	IQMod_magnitude_get_CH4(slave, 78),

	Best_S11_Freq_CH1(slave, 80),
	Best_S11_Freq_CH2(slave, 82),
	Best_S11_Freq_CH3(slave, 84),
	Best_S11_Freq_CH4(slave, 86),

	Best_S11_dB_CH1(slave, 88),
	Best_S11_dB_CH2(slave, 90),
	Best_S11_dB_CH3(slave, 92),
	Best_S11_dB_CH4(slave, 94),

	RFE_DLL_get_bitmask(slave, 96),
	feedforward_enable_get_bitmask(slave, 97)
//	RF_enable_get_bitmask(slave, 64)
{}
